/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.appserver;

import com.filenet.wcm.api.Session;
import com.filenet.wcm.toolkit.server.util.WcmDataStore;
import com.filenet.wcm.toolkit.server.util.WcmServerCredentials;
import filenet.vw.base.logging.Logger;
import filenet.vw.soap.server.VWPreferencesHelper;
import filenet.ws.listener.utils.WSListenerProperties;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class VWSIMSOAPSessionInfo {
    private static final Logger logger = Logger.getLogger("filenet.sim.appserver");
    private static final String m_className = "VWSIMSOAPSessionInfo";
    private Session session = null;
    private String user = null;
    private String password = null;
    private String token = null;
    private String simEngUrl = null;
    private boolean isSSO = false;
    private String connectionPoint = null;

    public String getConnectionPoint() {
        return this.connectionPoint;
    }

    public boolean getIsSSO() {
        return this.isSSO;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public Session getSession() {
        return this.session;
    }

    public String getSimEngUrl() {
        return this.simEngUrl;
    }

    public void verifyCredentials(ServletContext application, HttpServletRequest request, WSListenerProperties wsListenerProperties) throws Exception {
        String m_method = "verifyCredentials";
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "retrieving connectionPoint from Site Preference");
        }
        try {
            String[] cps = VWPreferencesHelper.getConfiguredConnectionPoints(application, request);
            if (cps != null) {
                this.connectionPoint = cps[0];
                if (wsListenerProperties != null) {
                    wsListenerProperties.setStanza(this.connectionPoint);
                }
            }
            logger.info(m_className, m_method, "Current user =" + this.user + ", cp=" + this.connectionPoint);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
        WcmDataStore ds = WcmDataStore.get((ServletContext)application, (HttpServletRequest)request);
        WcmServerCredentials cred = (WcmServerCredentials)ds.getValue("global.userCredentials");
        if (cred == null) {
            Exception e = new Exception("VWSIMSOAPSessionInfo.verifyCredentials1: Credentials are not available.");
            throw e;
        }
        try {
            this.isSSO = cred.isContainerJAASMode();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.session = cred.getSession();
        if (this.session == null) {
            e = new Exception("VWSIMSOAPSessionInfo.verifyCredentials2: Session not available.");
            throw e;
        }
        this.token = this.session.getToken();
        HashMap map = this.session.fromToken(this.token);
        if (this.isSSO) {
            if (wsListenerProperties != null) {
                this.user = wsListenerProperties.getUserName();
                this.password = wsListenerProperties.getPassword();
            } else {
                this.user = "";
                this.password = "";
            }
        } else {
            this.user = (String)map.get("userid");
            this.password = (String)map.get("password");
        }
        if (this.simEngUrl != null) {
            logger.info(m_className, m_method, "Current user =" + this.user + ", simEngUrl=" + this.simEngUrl);
        } else {
            logger.info(m_className, m_method, "current user =" + this.user);
        }
        if (this.simEngUrl == null) {
            try {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "retrieving simEngUrl from Site Preference");
                }
                this.simEngUrl = VWPreferencesHelper.getConfiguredSimEngUrl(application, request);
                logger.info(m_className, m_method, "Current user =" + this.user + ", simEngUrl=" + this.simEngUrl);
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
            }
        }
    }
}

